 ; Ŀ
 ;   Tarc - move a circle to be tangent to two others.                     
 ;   Copyright 2004 by Rocket Software Ltd.                                
 ;   Contains a few useful Trigonomety functions.                          
 ;   Implanted computers: make yourself obsolete along with your hardware. 
 ; 

 ; Ŀ
 ;   Carca - Find an angle given three sides of a triangle.                
 ;   Arguments: Lena, the length of the side opposite the desired angle.   
 ;              Lenb, the length of another side.                          
 ;              Lenc, the length of the last side.                         
 ;                                                                         
 ;   Calls nothing, returns an angle (in radians.)                         
 ; 
 (DEFUN CARCA (lena lenb lenc / denom numer tota angg)
  (setq denom (- (+ (* lenb lenb) (* lenc lenc)) (* lena lena)))
  (setq numer (* 2 lenb lenc))
  (setq tota (/ denom numer))
  (setq angg (jarc tota))
 angg)
 ; Ŀ
 ;   Carca end.                                                            
 ; 

 ; Ŀ
 ;   Jarc - Find an angle given the cosine thereof.                        
 ;   Arguments: Cang, The cosine of the desired angle.                     
 ;   Calls nothing, returns an angle (in radians.)                         
 ; 
 (DEFUN JARC (cang / sang tang orang)
 ; Ŀ
 ;   Get Sin from Cos - Sin^2 + Cos^2 = 1.                                 
 ; 
  (setq sang (sqrt (abs (- 1 (* cang cang)))))
 ; Ŀ
 ;   Tan = Sin/Cos.                                                        
 ; 
  (setq tang (/ sang cang))
 ; Ŀ
 ;   Arctan = -Tan = the original angle.                                   
 ; 
  (setq orang (atan tang))
 orang)
 ; Ŀ
 ;   Jarc end.                                                             
 ; 

 ; Ŀ
 ;   Subroutine Tarc.                                                      
 ; 
 (DEFUN TARC (cenama cenamb cenamc / entta enttb cena rada cenb radb enttc
                                     cenc radc lena lenb lenc anga bazang pa)
 ; Ŀ
 ;   Extract the various circle data.                                      
 ; 
  (setq entta (entget cenama))
  (setq enttb (entget cenamb))
  (setq enttc (entget cenamc))
  (setq cena (cdr (assoc 10 entta)))
  (setq rada (cdr (assoc 40 entta)))
  (setq cenb (cdr (assoc 10 enttb)))
  (setq radb (cdr (assoc 40 enttb)))
  (setq cenc (cdr (assoc 10 enttc)))
  (setq radc (cdr (assoc 40 enttc)))
 ; Ŀ
 ;   Now construct the hypothetical triangle with one vertex at the        
 ;   centre of each of the three circles.                                  
 ;   First get the side lengths.  The circles may not be touching, so      
 ;   the baseline length is actual, the lines to the circle to be moved    
 ;   are theoretical.                                                      
 ; 
  (setq lena (+ radb radc))    ; base circle cen to desired target circle cen
  (setq lenb (+ rada radc))    ; base circle 2 cen to desired target circle cen
;  (setq lenc (+ rada radb))   ; base circle cen to base circle 2 cen
  (setq lenc (distance cena cenb)) ; base circle cen to base circle 2 cen
 ; Ŀ
 ;   If the baseline is longer than the sum of the lengths of the two      
 ;   theoretical legs then there is no move position.                      
 ; 
  (if (> lenc (+ lena lenb))
      (prompt "\nNo possible move position.")
      (progn
 ; Ŀ
 ;   And get the angle for each vertex.                                    
 ;   Actually only need one angle, the one returned is that of the first   
 ;   circle chosen.                                                        
 ; 
           (setq anga (carca lena lenb lenc))
 ; Ŀ
 ;   Of course this angle is relative to the angle between the first and   
 ;   second circles.                                                       
 ; 
           (setq bazang (angle cena cenb))
           (setq anga (- bazang anga))
 ; Ŀ
 ;   Can now determine the desired centre of the circle to move.           
 ; 
           (setq pa (polar cena anga lenb))
           (entmod (subst (cons 10 pa) (assoc 10 enttc) enttc))))
 (princ))
 ; Ŀ
 ;   Subroutine Tarc end.                                                  
 ; 

 ; Ŀ
 ;   Tarc.                                                                 
 ; 
 (DEFUN C:TARC (/ cenama cenamb cenamc cena cenb cenc angg cenc-2 bapt tangl
                                                                       dirac)
  (command "undo" "be")
 ; Ŀ
 ;   Get two target circles and one to move.                               
 ; 
  (if (setq cenama (entsel "\nBase circle 1:"))
      (setq cenama (car cenama)))
  (if (setq cenamb (entsel "\nBase circle 2:"))
      (setq cenamb (car cenamb)))
  (if (setq cenamc (entsel "\nCircle to move:"))
      (setq cenamc (car cenamc)))
 ; Ŀ
 ;   The target circle will be moved to the right side of a line (taken    
 ;   as being the local up) from the first to the second base circle       
 ;   centres.  So if the target circle is on the left then the order in    
 ;   which the enames of the two base circles are given to the subroutine  
 ;   Carca must be reversed.                                               
 ;   So get all three circle centres.                                      
 ; 
  (setq cena (cdr (assoc 10 (entget cenama))))
  (setq cenb (cdr (assoc 10 (entget cenamb))))
  (setq cenc (cdr (assoc 10 (entget cenamc))))
 ; Ŀ
 ;   Get the angle between the first base circle to the second.            
 ; 
  (setq angg (angle cena cenb))
 ; Ŀ
 ;   And the angle of a line perpendicular to the baseline and through     
 ;   the target circle.                                                    
 ; 
  (setq cenc-2 (polar cenc (+ angg (/ pi 2)) 10))
  (setq bapt (inters cena cenb cenc cenc-2 ()))
  (setq tangl (angle bapt cenc))
 ; Ŀ
 ;   See if the base Up angle is between zero and pi radians.              
 ;   Then assign Left or right based on the relationship between the       
 ;   baseline Up (Angg) and the circle angle Tangl.                        
 ; 
  (if (and (> angg 0) (< angg pi))
      (if (and (> tangl angg) (< tangl (+ angg pi)))
          (setq dirac "Left")
          (setq dirac "Right"))
      (if (and (< tangl angg) (> tangl (- angg pi)))
          (setq dirac "Right")
          (setq dirac "Left")))
 ; Ŀ
 ;   Now call Tarc to move the circle depending on the value of Dirac.     
 ; 
  (if (= dirac "Left")
      (tarc cenamb cenama cenamc)
      (tarc cenama cenamb cenamc))
 ; Ŀ
 ;   End neatly.                                                           
 ; 
  (command "undo" "end")
 (princ))